<?php
/* --------------------------------------------------------------
   AccountEditThemeContentView.inc.php 2025-03-14
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2025 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------


   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(account_edit.php,v 1.63 2003/05/19); www.oscommerce.com
   (c) 2003	 nextcommerce (account_edit.php,v 1.14 2003/08/17); www.nextcommerce.org
   (c) 2003 XT-Commerce - community made shopping http://www.xt-commerce.com ($Id: account_edit.php 1314 2005-10-20 14:00:46Z mz $)

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

use Gambio\Admin\Modules\Customer\App\CustomerValidationService;
use Gambio\Core\Configuration\App\ConfigurationService;

class AccountEditThemeContentView extends ThemeContentView
{
    protected $error_array         = [];
    protected $customer_data_array = [];
    protected $page_token = '';
    
    protected CustomerValidationService $customerValidationService;
    
    protected ConfigurationService $configurationService;
    
    protected bool $firstnameAndLastnameOptional = false;
    
    protected bool $isCompanyRequired = false;
    
    function __construct()
    {
        parent::__construct();
        
        $this->set_content_template('account_edit.html');
        $this->set_flat_assigns(true);
        $this->set_caching_enabled(false);
        $this->configurationService = LegacyDependencyContainer::getInstance()->get(\Gambio\Core\Configuration\Services\ConfigurationService::class);
        $this->customerValidationService = LegacyDependencyContainer::getInstance()->get(CustomerValidationService::class);
        $this->firstnameAndLastnameOptional = $this->getFirstnameLastnameOptionalConfiguration();
    }
    
    
    protected function set_validation_rules()
    {
        $this->validation_rules_array['customer_data_array'] = ['type' => 'array'];
        $this->validation_rules_array['error_array']         = ['type' => 'array'];
        $this->validation_rules_array['page_token' ]         = ['type' => 'string'];
    }
    
    
    public function prepare_data()
    {
        $this->add_error_messages();
        $this->add_data();
    }
    
    
    protected function add_data()
    {
        if (is_array($this->content_array['form_data'] ?? null) == false) {
            $this->content_array['form_data'] = [];
        }
        
        $this->add_form();
        $this->add_gender();
        $this->add_vat();
        $this->add_firstname();
        $this->add_lastname();
        $this->add_company();
        $this->add_birthdate();
        $this->add_email();
        $this->add_telephone();
        $this->add_fax();
        $this->add_privacy();
        $this->add_page_token();
    }
    
    
    protected function add_form()
    {
        $t_form_action                          = xtc_href_link(FILENAME_ACCOUNT_EDIT, '', 'SSL');
        $this->content_array['FORM_ID']         = 'account_edit';
        $this->content_array['FORM_METHOD']     = 'post';
        $this->content_array['FORM_ACTION_URL'] = $t_form_action;
        
        $this->content_array['BUTTON_BACK_LINK'] = xtc_href_link(FILENAME_ACCOUNT, '', 'SSL');
        
        $this->content_array['HIDDEN_FIELD_NAME']  = 'action';
        $this->content_array['HIDDEN_FIELD_VALUE'] = 'process';
    }
    
    
    protected function add_gender()
    {
        if (ACCOUNT_GENDER == 'true') {
            $this->content_array['gender'] = '1';
            
            $this->content_array['form_data']['gender']                 = [];
            $this->content_array['form_data']['gender']['m']            = [];
            $this->content_array['form_data']['gender']['f']            = [];
            $this->content_array['form_data']['gender']['o']            = [];
            $this->content_array['form_data']['gender']['name']         = 'gender';
            $this->content_array['form_data']['gender']['m']['value']   = 'm';
            $this->content_array['form_data']['gender']['f']['value']   = 'f';
            $this->content_array['form_data']['gender']['o']['value']   = 'o';
            $this->content_array['form_data']['gender']['m']['checked'] = '0';
            $this->content_array['form_data']['gender']['f']['checked'] = '0';
            $this->content_array['form_data']['gender']['o']['checked'] = '0';
            
            if ($this->customer_data_array['gender'] == 'm') {
                $this->content_array['form_data']['gender']['m']['checked'] = '1';
            }
            if ($this->customer_data_array['gender'] == 'f') {
                $this->content_array['form_data']['gender']['f']['checked'] = '1';
            }
            if ($this->customer_data_array['gender'] == 'o') {
                $this->content_array['form_data']['gender']['o']['checked'] = '1';
            }
            
            if (GENDER_MANDATORY === 'true') {
                $this->content_array['form_data']['gender']['required'] = 1;
            }
        }
    }
    
    
    protected function add_vat()
    {
        if (ACCOUNT_COMPANY === 'true' && ACCOUNT_COMPANY_VAT_CHECK === 'true') {
            
            $this->content_array['vat']                          = '1';
            $this->content_array['form_data']['vat']             = [];
            $this->content_array['form_data']['vat']['name']     = 'vat';
            $this->content_array['form_data']['vat']['value']    = htmlspecialchars_wrapper($this->customer_data_array['vat_id'] ?? '');
            $this->content_array['form_data']['vat']['required'] = 0;
        } else {
            $this->content_array['vat'] = '0';
        }
    }
    
    
    protected function add_firstname()
    {
        $this->content_array['form_data']['firstname']             = [];
        $this->content_array['form_data']['firstname']['name']     = 'firstname';
        $this->content_array['form_data']['firstname']['value']    = htmlspecialchars_wrapper($this->customer_data_array['firstname'] ?? '');
        $this->content_array['form_data']['firstname']['required'] = 0;
        if(!$this->firstnameAndLastnameOptional && (int)ENTRY_FIRST_NAME_MIN_LENGTH > 0) {
            $this->content_array['form_data']['firstname']['required'] = 1;
        }
    }
    
    
    /**
     * @return void
     */
    protected function add_company(): void
    {
        if($this->customerValidationService->isCompanyEnabled()) {
            $this->content_array['form_data']['company']             = [];
            $this->content_array['form_data']['company']['name']     = 'company';
            $this->content_array['form_data']['company']['value']    = htmlspecialchars_wrapper($this->customer_data_array['company']
                                                                                                ?? '');
            $this->content_array['form_data']['company']['required'] = $this->customerValidationService->isCompanyRequired();
        }
    }
    
    
    protected function add_lastname()
    {
        $this->content_array['form_data']['lastname']             = [];
        $this->content_array['form_data']['lastname']['name']     = 'lastname';
        $this->content_array['form_data']['lastname']['value']    = htmlspecialchars_wrapper($this->customer_data_array['lastname'] ?? '');
        $this->content_array['form_data']['lastname']['required'] = 0;
        if (!$this->firstnameAndLastnameOptional && (int)ENTRY_LAST_NAME_MIN_LENGTH > 0) {
            $this->content_array['form_data']['lastname']['required'] = 1;
        }
    }
    
    
    protected function add_birthdate()
    {
        if (ACCOUNT_DOB == 'true') {
            $this->content_array['birthdate']                               = '1';
            $this->content_array['form_data']['birthdate']                  = [];
            $this->content_array['form_data']['birthdate']['name']          = 'dob';
            $this->content_array['form_data']['birthdate']['format']        = DOB_FORMAT_STRING;
            $this->content_array['form_data']['birthdate']['value']         = htmlspecialchars_wrapper($this->customer_data_array['dob']
                                                                                                       ?? '');
            $this->content_array['form_data']['birthdate']['default_value'] = "-6570"; // use 18 years as default start year
            $this->content_array['form_data']['birthdate']['required']      = 0;
            if ((int)ENTRY_DOB_MIN_LENGTH > 0) {
                $this->content_array['form_data']['birthdate']['required'] = 1;
            }
        } else {
            $this->content_array['birthdate'] = '0';
        }
    }
    
    
    protected function add_email()
    {
        $this->content_array['form_data']['email']             = [];
        $this->content_array['form_data']['email']['name']     = 'email_address';
        $this->content_array['form_data']['email']['value']    = htmlspecialchars_wrapper($this->customer_data_array['email_address'] ?? '');
        $this->content_array['form_data']['email']['required'] = 0;
        if ((int)ENTRY_EMAIL_ADDRESS_MIN_LENGTH > 0) {
            $this->content_array['form_data']['email']['required'] = 1;
        }
    }
    
    
    protected function add_telephone()
    {
        $this->content_array['telephone'] = '0';
        
        if (ACCOUNT_TELEPHONE == 'true') {
            $this->content_array['telephone']                          = '1';
            $this->content_array['form_data']['telephone']             = [];
            $this->content_array['form_data']['telephone']['name']     = 'telephone';
            $this->content_array['form_data']['telephone']['value']    = htmlspecialchars_wrapper($this->customer_data_array['telephone'] ?? '');
            $this->content_array['form_data']['telephone']['required'] = 0;
            if ((int)ENTRY_TELEPHONE_MIN_LENGTH > 0) {
                $this->content_array['form_data']['telephone']['required'] = 1;
            }
        }
    }
    
    
    protected function add_fax()
    {
        $this->content_array['fax'] = '0';
        
        if (ACCOUNT_FAX == 'true') {
            $this->content_array['fax']                          = '1';
            $this->content_array['form_data']['fax']             = [];
            $this->content_array['form_data']['fax']['name']     = 'fax';
            $this->content_array['form_data']['fax']['value']    = htmlspecialchars_wrapper($this->customer_data_array['fax'] ?? '');
            $this->content_array['form_data']['fax']['required'] = 0;
        }
    }
    
    
    protected function add_privacy()
    {
        $this->content_array['GM_PRIVACY_LINK'] = gm_get_privacy_link('GM_CHECK_PRIVACY_ACCOUNT_CONTACT');
        
        $this->content_array['show_privacy_checkbox']                  = gm_get_conf('PRIVACY_CHECKBOX_ACCOUNT_EDIT');
        $this->content_array['form_data']['privacy_accepted']['value'] = (int)($this->customer_data_array['privacy_accepted'] ?? 0);
    }
    
    
    protected function add_error_messages()
    {
        if (is_array($this->error_array) && empty($this->error_array) == false) {
            foreach ($this->error_array as $t_error => $t_error_text) {
                $this->content_array[$t_error] = $t_error_text;
                $GLOBALS['messageStack']->add('account_edit', $t_error_text);
            }
            
            if ($GLOBALS['messageStack']->size('account_edit') > 0) {
                $this->content_array['error'] = $GLOBALS['messageStack']->output('account_edit');
            }
        }
    }
    
    
    protected function add_page_token()
    {
        $this->content_array['form_data']['page_token'] = $this->page_token;
    }
    
    private function getFirstnameLastnameOptionalConfiguration(): bool
    {
        $currentConfiguration = $this->configurationService->find('configuration/ACCOUNT_NAMES_OPTIONAL')?->value();
        return $currentConfiguration === 'true';
    }
}
